function [col_ass,col_default] = visualize_colors

% This is an internal routine for the graphical interface of the toolbox.
% The main routine to open the graphical interface is class_gui
%
% HELP:
% note that a detailed HTML help is provided with the toolbox,
% see the HTML HELP files (help.htm) for futher details and examples
%
% LICENCE:
% This toolbox is distributed with an Attribution-NonCommercial-NoDerivatives 4.0 International (CC BY-NC-ND 4.0) licence: https://creativecommons.org/licenses/by-nc-nd/4.0/
% You are free to share - copy and redistribute the material in any medium or format. The licensor cannot revoke these freedoms as long as you follow the following license terms:
% Attribution - You must give appropriate credit, provide a link to the license, and indicate if changes were made. You may do so in any reasonable manner, but not in any way that suggests the licensor endorses you or your use.
% NonCommercial - You may not use the material for commercial purposes.
% NoDerivatives - If you remix, transform, or build upon the material, you may not distribute the modified material.
%
% REFERENCE:
% The toolbox is freeware and may be used if proper reference is given to the authors, preferably refer to the following paper:
% Ballabio D, Consonni V, (2013) Classification tools in chemistry. Part 1: Linear models. PLS-DA. Analytical Methods, 5, 3790-3798
% 
% Classification toolbox for MATLAB
% version 6.0 - October 2021
% Davide Ballabio
% Milano Chemometrics and QSAR Research Group
% http://www.michem.unimib.it/

col_default(1,:) = [0 0.447 0.741]; % default blue for plots

col_ass(1,:)  = [1.0 1.0 1.0]; % white, not assigned
col_ass(2,:)  = [0.5 0.5 1.0];
col_ass(3,:)  = [1.0 0.5 0.5];
col_ass(4,:)  = [0.5 1.0 0.5];   
col_ass(5,:)  = [1 0.83 0];
col_ass(6,:)  = [1 0.10 0.72];
col_ass(7,:)  = [0 0.35 0];
col_ass(8,:)  = [0.65 0.65 0.65];
col_ass(9,:)  = [0 0.52 0.59];
col_ass(10,:) = [0.62 0.31 0.27];
col_ass(11,:) = [0.96 0.62 0.86];
col_ass(12,:) = [0 1 0.76];
col_ass(13,:) = [0.49 0.18 0.56];
col_ass(14,:) = [0 0 0.48];
col_ass(15,:) = [0.58 0.82 0.31];
col_ass(16,:) = [0 0 0.17];
col_ass(17,:) = [0.83 0.06 1];
col_ass(18,:) = [0.48 0.10 0.41];
col_ass(19,:) = [0.96 0.06 0.38];
col_ass(20,:) = [1 0.75 0.51];
col_ass(21,:) = [0.55 0.65 0.48];